/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.datamodel.table;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.table.PmSimpleCellInfo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class PmDateCellInfo
extends PmSimpleCellInfo {
    private String pattern;

    public void setDateFormatPattern(String newPattern) {
        if (newPattern != null) {
            boolean valid = false;
            boolean error = false;
            boolean hasYear = false;
            boolean hasMonth = false;
            boolean hasDate = false;
            boolean inYear = false;
            boolean inMonth = false;
            boolean inDate = false;
            int length = newPattern.length();
            int i = 0;
            while (!error && i < length) {
                char ch = newPattern.charAt(i);
                switch (ch) {
                    case 'y': {
                        hasYear = true;
                        inYear = !inMonth && !inDate;
                        error = !inYear;
                        break;
                    }
                    case 'M': {
                        hasMonth = true;
                        inMonth = !inYear && !inDate;
                        error = !inMonth;
                        break;
                    }
                    case 'd': {
                        hasDate = true;
                        inDate = !inYear && !inMonth;
                        error = !inDate;
                        break;
                    }
                    default: {
                        error = Character.isLetterOrDigit(ch) || !inYear && !inMonth && !inDate;
                        inYear = false;
                        inMonth = false;
                        inDate = false;
                    }
                }
                ++i;
            }
            if (error || !hasYear || !hasMonth || !hasDate) {
                throw new IllegalArgumentException("Date format pattern not valid: " + newPattern);
            }
        }
        this.pattern = newPattern;
    }

    public String getDateFormatPattern(Locale locale) {
        if (this.pattern != null) {
            return this.pattern;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        return sdf.toPattern();
    }
}

